<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
* @filesource
*/
require_once APPPATH.'/third_party/WkHtmlToPdf.php';
require_once 'restricted_controller.php';
require_once APPPATH.'models/mailbox.php';

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*/
class Reports extends Restricted_controller {

	/**
	 * Reports Controller
	 *
	 */
	function __construct() {
		parent::__construct();
		//get group mailbox information
		$group_mailboxes = $this->session->userdata('group_mailboxes');
		//currently selected mailbox - personal or group
		$mailbox_group = $this->session->userdata('mailbox_group');
		//default to the user's personal mailbox if we don't have a mailbox selected or if no group mailboxes are available or if the mailbox group isn't valid
		if(empty($mailbox_group) || empty($group_mailboxes) || !array_key_exists($mailbox_group, $group_mailboxes) || !Mailbox::exists( array('user_name' => $mailbox_group) )){
			$mailbox_group = $this->session->userdata('username');
		}
		$this->mailbox = Mailbox::find_one( array('user_name' => $mailbox_group) );
#TODO - special case for if we still don't have a mailbox? or if mailbox isn't active?
		//set the session mailbox group in case we've changed it
		$this->session->set_userdata('mailbox_group', $mailbox_group);		
	}
	
	public function get_mailbox_activities() {
		$data['title'] = PORTAL_TITLE_PREFIX . 'Reports';
		$not_first_visit = $this->input->post('not_first_visit', TRUE);
		$facility_id = $this->input->post('facility_id', TRUE);
		$form_data = $this->input->post(NULL, TRUE);
		
		if(isset($form_data['selected_user'])){
			$this->verify_permission("report_admin");
			$username = $form_data['selected_user'];
		}
		else{
			$username = $this->session->userdata('username');
		}
		if($this->has_permission("report_admin")){
			$get_users = $this->db->query("SELECT user_name from users where user_is_group = 0");
			if($get_users){
				$get_users = $get_users->result();
				$users = array();
				foreach ($get_users as $user){
					$users[] =$user->user_name;
				}
				sort($users);
			}
		}
		//get group mailboxes directy from LDAP
		$group_mailboxes = $this->ldap->get_group_membership('uid='.$username.','.LDAP_ACCOUNTS_DN);
		$group_mailboxes_str = '';
		foreach($group_mailboxes as $name => $cn) { $group_mailboxes_str .= $name . ','; }
		$group_mailboxes_str = replace_last_with(',', '', $group_mailboxes_str);
		
		//if a POST request was submitted
		if($not_first_visit) {
			
			//check whether or not their is a filter request and what the filter input is
			$start_date = $this->input->post('start_date', TRUE);
			$end_date = $this->input->post('end_date', TRUE);
			$date_array = array($end_date, $start_date);
			$date_warning_message = $this->get_date_filter_validation_message($date_array);
			
			//check whether or not there is a sort request and set the sort direction
			$order = $this->input->post('order', TRUE);
			$dir = $this->direction_check($this->input->post('order', TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
			
			//check whether or not there is an export request, and if so which type
			$export = $this->input->post('export', TRUE);
			$export_pdf = $this->input->post('export_pdf', TRUE);
			$print_page = $this->input->post('print_page', TRUE);
			$is_export = 0;
			if($export) { $is_export = 'excel'; }
			else if($export_pdf) { $is_export = 'pdf'; }
			else if($print_page) { $is_export = 'print'; }
			
			//create filter based on input
			$filter = '';
			if(!empty($start_date)) {
				$filter .= '/start_date/' . rawurlencode(base64_encode($start_date));
			}
			if(!empty($end_date)) {
				$filter .= '/end_date/' . rawurlencode(base64_encode($end_date));
			}
			//set sorting based on input
			$sorting = '';
			if(!empty($order) && !empty($dir)) {
				$sorting .= '/order/' . rawurlencode(base64_encode($order)) . '/direction/' . $dir;
			}
			
			//create API call
			$resource = '/direct/reports/get_mailbox_activities/username/'.$username;
			if(!empty($group_mailboxes_str)) { $resource .='/groupnames/'.rawurlencode(base64_encode($group_mailboxes_str)); }
			$resource .= '/export/'. $is_export . $filter . $sorting;
			$resource .= '/format/json';
			//make API call
			$request = $this->api_model->webservice_call($resource,'GET');
			//if API can't find the resource, return a 404
			
			if($request->http_status === 200) {
				$data['message_counts'] = $request->response->message_counts;
				//$data['facilities'] = $request->response->facilities;
				$data['is_export'] = $is_export;
				
				//save form data from POST to keep the values in the view
				$form_data['direction'] = $dir;
					
				//gets image for asc or desc
				if($form_data['direction'] == 'DESC'){ $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>'; }
				else { $data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>"; }
			}
			else if($request->http_status === 403 ){
				$data['error'] = "unauth";
			}
			else{
				$data['error'] = "other";
			}
			$form_data['date_warning_message'] = $date_warning_message;
		}
		else {
			$resource = '/direct/reports/get_mailbox_activities/username/'.$this->session->userdata('username');
			if(!empty($group_mailboxes_str)) { $resource .='/groupnames/'.rawurlencode(base64_encode($group_mailboxes_str)); }
			$resource .= '/order/' . rawurlencode(base64_encode('default_order')) . '/direction/ASC';
			$resource .= '/format/json';
			$request = $this->api_model->webservice_call($resource,'GET');
			if($request->http_status === 404) {
				show_404();
			}
			else if($request->http_status === 200) {
				$data['message_counts'] = $request->response->message_counts;
				$form_data = array(
						'direction' =>'ASC',
						'order'=>'default_order',
						'cur_page'=>'1',
						'selected_user'=>$this->session->userdata('username'),
				);
			}
			$export = false;
			$export_pdf = false;
			$print_page = false;
		}
		if(isset($users)){
			$form_data['users'] = ($users);
		}
		$data['form_data'] = $form_data;
		if($export){
			$this->export_excel(array('Direct Address','Total Messages Sent by You', 'Total Messages Sent', 'Total Messages Received', 'Total Messages'),$request->response->message_counts,'mailbox_activities');
		}
		else if($export_pdf) {
			$html = $this->load->view('reports/result_tables/result_mailbox_activities', $data, true);
			$this->export_pdf('Mailbox Act.pdf', $html);
		}
		else if($print_page) {
			$data['print_page'] = true;
			$this->load->view('reports/result_tables/result_mailbox_activities', $data);
		}
		else{
			$this->load->view('reports/mailbox_activities', $data);
		}
	}
	
	public function index()
	{	
		//for now call the default report
		$this->get_mailbox_activities();
	}
	
	/*
	 * checks if dates are valid and returns a warning message if not
	*/
	private function get_date_filter_validation_message($dates) {
		$invalid_date = 0;
		$warning_message = null;
		foreach($dates as $date) {
			if(!empty($date) && !strtotime($date)) {
				$invalid_date = $invalid_date + 1;
			}
		}
		if($invalid_date > 1) {
			$warning_message = 'The invalid date inputs have been ignored.';
		}
		else if($invalid_date > 0) {
			$warning_message = 'The invalid date input has been ignored.';
		}
	
		return $warning_message;
	}
	
	//chooses which (asc or desc) the table should be
	private function direction_check($order,$lastorder,$direction,$change){
		//reloaded by filter and not clicking to change direction.  also make sure that it was not changed by user
		if ($change == 'false' && ($direction == "DESC" || $direction == "ASC")){
			return $direction;
		}
		//colum selected is same as last
		if($order == $lastorder){
			if($direction == 'DESC'){
				return 'ASC';
			}
			else{
				return "DESC";
			}
		}
		//clicked on new colum
		else{
			return "DESC";
		}
	}
	
	/*
	 * export is used for exporting the results to excel
	*/
	private function export_excel($header,$results,$name){
		header('Content-Type: application/download');
		header('Content-Transfer-Encoding: binary');
		header('Content-Disposition: attachment; filename="'.$name.'.csv"');
		$fp = fopen('php://output', 'w');
		fputcsv($fp,  array('FOR OFFICIAL USE ONLY'));
		fputcsv($fp,  array('Mailbox Activities'));
		fputcsv ($fp, $header);
		foreach($results as $result) {
			$row=array();
			foreach($result as $part) {
				array_push($row,$part);
			}
			fputcsv ($fp, $row);
		}
	
		fclose($fp);
	}
	
	private function export_pdf($file_name, $html) {
	
		$pdf = new WkHtmlToPdf(array(
				'binPath' => WKHTMLTOPDF_EXE_PATH
		));
		// Add a HTML string
		$pdf->addPage($html);
		if(!$pdf->send($file_name))
			throw new Exception('Could not create PDF: '.$pdf->getError());
	}
	
	private function get_user_ldap_info() {
		$resource = '/direct/account/mailbox/'.$this->session->userdata('username');
		$resource .= '/format/json';
		return $this->api_model->webservice_call($resource,'GET');
	}
}

/* End of file reports.php */
/* Location: ./application/controllers/reports.php */
